//
//  SignUpViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 17/10/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let STORYBOARD_ID_CMSSignUpViewController = "CMSSignUpViewController"
import UIKit

class CMSSignUpViewController: UIViewController, UITextFieldDelegate, CMSNetworkManager_RegisterDelegate {
    @IBOutlet var txtUsername: UITextField!
    @IBOutlet var txtPassword: UITextField!
    @IBOutlet var txtConfirmPassword: UITextField!
    @IBOutlet var txtEmail: UITextField!
    @IBOutlet var txtConfirmEmail: UITextField!
    @IBOutlet var txtDOB: UITextField!
    @IBOutlet weak var lblUsername: UILabel!
    @IBOutlet weak var lblPassword: UILabel!
    @IBOutlet weak var lblConfirmPassword: UILabel!
    @IBOutlet weak var lblEmail: UILabel!
    @IBOutlet weak var lblConfirmEmail: UILabel!
    @IBOutlet weak var lblDOB: UILabel!
    @IBOutlet weak var btnSignup: UIButton!
    @IBOutlet weak var btnCancel: UIButton!

    @IBAction func btnSignup(sender: AnyObject) {
        var errorMessage = self.validateForm()
        if errorMessage != "" {
            UIAlertView(title: "", message: errorMessage, delegate: nil, cancelButtonTitle: nil).show()
            return
        }
        var localTime = NSTimeZone.systemTimeZone()
        var dob_day: String
        var dob_month: String
        var dob_year: String
        var dobParts = txtDOB.text.componentsSeparatedByString("-")
        dob_year = dobParts[0]
        dob_month = dobParts[1]
        dob_day = dobParts[2]
        CMSNetworkManager.sharedManager().registerDelegate = self
        CMSNetworkManager.sharedManager().registerWithUsername(txtUsername.text, password: txtPassword.text, confirmPassword: txtConfirmPassword.text, email: txtEmail.text, confirmEmail: txtConfirmEmail.text, dob_day: dob_day, dob_month: dob_month, dob_year: dob_year, timezone: localTime.name, onCompletion: nil, onFaillure: nil, showLoader: true)
    }

    @IBAction func btnSignupCancel(sender: AnyObject) {
        if self.isPresentedAsModal() {
            self.dismissViewControllerAnimated(true, completion: { _ in })
        }
        else {
            self.navigationController!.popViewControllerAnimated(true)!
        }
    }
    var pickerView: UIDatePicker!
    var dateFormatter: NSDateFormatter!



    convenience override init() {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSSignUpViewController)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.lblUsername.text = CMS_Langs.do_lang(LABEL_SIGNUP_USERNAME)
        self.lblPassword.text = CMS_Langs.do_lang(LABEL_SIGNUP_PASSWORD)
        self.lblConfirmPassword.text = CMS_Langs.do_lang(LABEL_SIGNUP_CONFIRM_PASSWORD)
        self.lblEmail.text = CMS_Langs.do_lang(LABEL_SIGNUP_EMAIL)
        self.lblConfirmEmail.text = CMS_Langs.do_lang(LABEL_SIGNUP_CONFIRM_EMAIL)
        self.lblDOB.text = CMS_Langs.do_lang(LABEL_SIGNUP_DOB)
        self.btnSignup.setTitle(CMS_Langs.do_lang(BUTTON_SIGNUP_SIGNUP), forState: .Normal)
        self.btnCancel.setTitle(CMS_Langs.do_lang(BUTTON_SIGNUP_CANCEL), forState: .Normal)
        self.title = "Sign Up"
        //setup date picker
        dateFormatter = NSDateFormatter()
        dateFormatter.dateFormat = NSDateFormatter.dateFormatFromTemplate("yyyy-MM-dd", options: [], locale: NSLocale.systemLocale())!
        pickerView = UIDatePicker()
        pickerView.datePickerMode = .Date
        pickerView.addTarget(self, action: self.dateChanged, forControlEvents: .ValueChanged)
        var toolbar = UIToolbar()
        toolbar.barStyle = .BlackTranslucent
        toolbar.sizeToFit()
        var flexibleSpaceLeft = UIBarButtonItem(barButtonSystemItem: .FlexibleSpace, target: nil, action: nil)
        var doneButton = UIBarButtonItem(title: "Done", style: .Done, target: self, action: self.doneClicked)
        toolbar.items = [flexibleSpaceLeft, doneButton]
        //custom input view
        txtDOB.inputView = pickerView
        txtDOB.inputAccessoryView! = toolbar
        var tap = UITapGestureRecognizer(target: self, action: self.singleTap)
        tap.numberOfTapsRequired = 1
        tap.numberOfTouchesRequired = 1
        self.view.addGestureRecognizer(tap)
    }

    func singleTap() {
        self.view.endEditing(true)
    }

    func isPresentedAsModal() -> Bool {
        var isModal = (self.parentViewController! && self.parentViewController!.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.parentViewController! && self.navigationController!.parentViewController!.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.parentViewController! is UITabBarController)
        //iOS 5+
        if !isModal && self.respondsToSelector(self.presentingViewController) {
            isModal = (self.presentingViewController && self.presentingViewController.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.presentingViewController && self.navigationController!.presentingViewController.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.presentingViewController! is UITabBarController)
        }
        return isModal
    }

    func doneClicked(sender: AnyObject) {
        txtDOB.text = dateFormatter.stringFromDate(pickerView.date!)
        txtDOB.resignFirstResponder()
        //hides the pickerView
    }

    @IBAction func dateChanged(sender: AnyObject) {
        txtDOB.text = dateFormatter.stringFromDate(pickerView.date!)
    }

    func validateForm() -> String {
        var errorMessage: String
        var regex = "[^@]+@[A-Za-z0-9.-]+\\.[A-Za-z]+"
        var emailPredicate = NSPredicate(format: "SELF MATCHES %@", regex)
        if !(self.txtUsername.text.length >= 1) {
            errorMessage = "Please enter a Username"
        }
        else if !(self.txtPassword.text.length >= 5) {
            errorMessage = "Please enter a Password with minimum of 5 letters"
        }
        else if !(self.txtConfirmPassword.text == self.txtPassword.text) {
            errorMessage = "Please correctly re-enter the password"
        }
        else if !emailPredicate.evaluateWithObject(self.txtEmail.text) {
            errorMessage = "Please enter a valid email address"
        }
        else if !(self.txtEmail.text == self.txtConfirmEmail.text) {
            errorMessage = "Please correctly re-enter the email address"
        }
        else if !(self.txtDOB.text.length > 0) {
            errorMessage = "Please enter your DOB"
        }

        return errorMessage
    }
// MARK: - TextFieldDelegate Methods

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        if textField == self.txtUsername {
            self.txtPassword.becomeFirstResponder()
        }
        else if textField == self.txtPassword {
            self.txtConfirmPassword.becomeFirstResponder()
        }
        else if textField == self.txtConfirmPassword {
            self.txtEmail.becomeFirstResponder()
        }
        else if textField == self.txtEmail {
            self.txtConfirmEmail.becomeFirstResponder()
        }
        else if textField == self.txtConfirmEmail {
            self.txtDOB.becomeFirstResponder()
        }
        else if textField == self.txtDOB {
            textField.resignFirstResponder()
        }

        return true
    }
// MARK: - CMSNetworkManager_RegisterDelegate methods

    func CMSNetworkManager(manager: CMSNetworkManager, didRegisterWithResponse response: [NSObject : AnyObject]) {
        print("Register Successful")
        print("\(response)")
        UIAlertView(title: response["response_data"]["message"], message: nil, delegate: nil, cancelButtonTitle: nil).show()
    }

    func CMSNetworkManager(manager: CMSNetworkManager, didFailToRegisterWithError error: NSError?) {
        UIAlertView(title: "Register failed", message: error.domain, delegate: nil, cancelButtonTitle: nil).show()
        print("\(error.description)")
    }
}
//
//  SignUpViewController.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 17/10/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let LABEL_SIGNUP_USERNAME = "LABEL_SIGNUP_USERNAME"
let LABEL_SIGNUP_PASSWORD = "LABEL_SIGNUP_PASSWORD"
let LABEL_SIGNUP_CONFIRM_PASSWORD = "LABEL_SIGNUP_CONFIRM_PASSWORD"
let LABEL_SIGNUP_EMAIL = "LABEL_SIGNUP_EMAIL"
let LABEL_SIGNUP_CONFIRM_EMAIL = "LABEL_SIGNUP_CONFIRM_EMAIL"
let LABEL_SIGNUP_DOB = "LABEL_SIGNUP_DOB"
let BUTTON_SIGNUP_SIGNUP = "BUTTON_SIGNUP_SIGNUP"
let BUTTON_SIGNUP_CANCEL = "BUTTON_SIGNUP_CANCEL"